IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_CLI_CONV_PBM_CONTROLE]') 
					AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [DBO].[P_RC_CLI_CONV_PBM_CONTROLE]
END
GO
--EXEC P_RC_CLI_CONV_PBM_CONTROLE 1, 1,1
CREATE PROCEDURE P_RC_CLI_CONV_PBM_CONTROLE @CD_EMP INT,
										    @CD_FILIAL INT,
											@FLAG_ANALISE INT=0
AS
begin
DECLARE @DT_ATUAL DATETIME
DECLARE @DT_PROC DATETIME
SET NOCOUNT ON;
DECLARE 
	@dtInicioMes DATETIME, 
	@dtInicioMesFechamento DATETIME, 
	@dtInicioMesAnterior DATETIME, 
	@dtDiaFinalMesFechamento DATETIME,
	@ano INT, 
	@mes VARCHAR(2),
	@anoAnt INT, 
	@mesAnt INT,
	@anoFecha INT, 
	@mesFecha INT,
	@QtdeMesesProc INT,
	@QtdeMesProc INT;

	SET @DT_ATUAL= GETDATE()
	SET @ANO=YEAR(@DT_ATUAL)
	SET @MES=MONTH(@DT_ATUAL)

DELETE
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD
FROM
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD INNER JOIN EST_PROD_RC_CLI_CONV ON
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_EMP = EST_PROD_RC_CLI_CONV.CD_EMP AND
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_PROD = EST_PROD_RC_CLI_CONV.CD_PROD 
WHERE
	EST_PROD_RC_CLI_CONV.REPOSICAO ='N'		

--Vinculo retirado pelo usuario da PBM
--**************************************************************
DELETE
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD
FROM
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD LEFT OUTER JOIN EST_PROD_RC_CLI_CONV ON
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_EMP = EST_PROD_RC_CLI_CONV.CD_EMP AND
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_PROD = EST_PROD_RC_CLI_CONV.CD_PROD 
WHERE
	EST_PROD_RC_CLI_CONV.CD_PROD IS NULL

DELETE
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL
FROM
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL LEFT OUTER JOIN EST_PROD_RC_CLI_CONV ON
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL.CD_EMP = EST_PROD_RC_CLI_CONV.CD_EMP AND
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL.CD_PROD = EST_PROD_RC_CLI_CONV.CD_PROD 
WHERE
	EST_PROD_RC_CLI_CONV.CD_PROD IS NULL

DELETE
	RC_CLI_CONV_PBM_CENTRALIZADO_CPL
FROM
	RC_CLI_CONV_PBM_CENTRALIZADO_CPL inner JOIN RC_CLI_CONV_PBM_CONTROLE_AJUSTES ON
	RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_CTR = RC_CLI_CONV_PBM_CENTRALIZADO_CPL.CD_CTR_AJUSTES 
	
DELETE
	RC_CLI_CONV_PBM_CONTROLE_AJUSTES
FROM
	RC_CLI_CONV_PBM_CONTROLE_AJUSTES LEFT OUTER JOIN EST_PROD_RC_CLI_CONV ON
	RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_EMP = EST_PROD_RC_CLI_CONV.CD_EMP AND
	RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_PROD = EST_PROD_RC_CLI_CONV.CD_PROD 
WHERE
	EST_PROD_RC_CLI_CONV.CD_PROD IS NULL	
--**************************************************************88
	
DELETE
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL
FROM
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL INNER JOIN EST_PROD_RC_CLI_CONV ON
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL.CD_EMP = EST_PROD_RC_CLI_CONV.CD_EMP AND
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL.CD_PROD = EST_PROD_RC_CLI_CONV.CD_PROD 
WHERE
	EST_PROD_RC_CLI_CONV.REPOSICAO ='N'	

	
IF  LEN(@mes)=1 
	SET @mes='0' + @mes

SELECT @dtInicioMes = convert(char(8),CONVERT(CHAR(4), @ano) +  @mes + '01');

CREATE TABLE #RsVendasPBMProc (CD_EMP INT,
							   CD_FILIAL INT,
							   CD_PROD INT,
							   QT_IT_VD MONEY,
							   QT_IT_ENT MONEY,
							   QT_IT_FECHA MONEY)

	SELECT @dtInicioMesFechamento= @dtInicioMes,
	@dtDiaFinalMesFechamento = DATEADD(DAY, -1, DATEADD(month, 1, @dtInicioMesFechamento)),
	@dtInicioMesAnterior =  DATEADD(month, -1, @dtInicioMesFechamento), 
	@anoAnt = DATEPART(year, @dtInicioMesAnterior), 
	@mesAnt=DATEPART(month, @dtInicioMesAnterior),
	@anoFecha=DATEPART(year, @dtInicioMesFechamento),
	@mesFecha =DATEPART(month, @dtInicioMesFechamento);
	PRINT 'Buscando dados ano\mes anterior '+ CONVERT( VARCHAR(10), @anoAnt) +' '+CONVERT(VARCHAR, @MesAnt, 112) + ' ' + convert(varchar,getdate(),108);          
	INSERT INTO #RsVendasPBMProc
	(CD_EMP,
	CD_FILIAL,
	CD_PROD,
	QT_IT_VD,
	QT_IT_ENT,
	QT_IT_FECHA)
	SELECT
		CD_EMP,
		CD_FILIAL,
		CD_PROD,
		0 AS QT_IT_VD,
		0 AS QT_IT_ENT,
		QT_SALDO AS QT_IT_FECHA
	FROM
		RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL
	WHERE
		ANO=@anoAnt
		AND MES=@mesAnt
		AND CD_EMP = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL

	PRINT 'Periodo analise '+ CONVERT(VARCHAR, @dtInicioMesFechamento, 112) +' a '+ CONVERT(VARCHAR, @dtDiaFinalMesFechamento, 112);          

	PRINT 'Gerando movimento de vendas '+  convert(varchar,getdate(),108);          
	INSERT INTO #RsVendasPBMProc
	(CD_EMP,
	CD_FILIAL,
	CD_PROD,
	QT_IT_VD,
	QT_IT_ENT,
	QT_IT_FECHA)
	SELECT
		PDV_VD_IT.CD_EMP,
		PDV_VD_IT.CD_FILIAL,
		PDV_VD_IT.CD_PROD,
		SUM(PDV_VD_IT.QT_IT) AS QT_IT_VD,
		0 AS QT_IT_ENT,
		0 AS QT_IT_FECHA
	FROM
		PDV_VD_IT INNER JOIN PDV_VD ON
		PDV_VD_IT.CD_EMP  = PDV_VD.CD_EMP AND
		PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
		PDV_VD_IT.CD_VD = PDV_VD.CD_VD 
		INNER JOIN PDV_VD_IT_VD_PBM ON
		PDV_VD_IT.CD_EMP= PDV_VD_IT_VD_PBM.CD_EMP AND
		PDV_VD_IT.CD_FILIAL = PDV_VD_IT_VD_PBM.CD_FILIAL AND
		PDV_VD_IT.CD_VD = PDV_VD_IT_VD_PBM.CD_VD AND
		PDV_VD_IT.CD_IT = PDV_VD_IT_VD_PBM.CD_IT 
		INNER JOIN RC_CLI_CONV_VINC_RC_CLI ON
		PDV_VD_IT_VD_PBM.CD_EMP = RC_CLI_CONV_VINC_RC_CLI.CD_EMP AND
		PDV_VD_IT_VD_PBM.CD_CLI_PBM = RC_CLI_CONV_VINC_RC_CLI.CD_CLI 
		INNER JOIN RC_CLI_CONV_PBM ON
		RC_CLI_CONV_VINC_RC_CLI.CD_EMP = RC_CLI_CONV_PBM.CD_EMP AND
		RC_CLI_CONV_VINC_RC_CLI.CD_CONV = RC_CLI_CONV_PBM.CD_CONV AND
		PDV_VD_IT.DT_VD >= RC_CLI_CONV_PBM.DT_ATIVAR_CONTROLE
		INNER JOIN EST_PROD_RC_CLI_CONV ON
		PDV_VD_IT.CD_EMP = EST_PROD_RC_CLI_CONV.CD_EMP AND
		PDV_VD_IT.CD_PROD = EST_PROD_RC_CLI_CONV.CD_PROD 
		LEFT OUTER JOIN PDV_VD_IT_VD_PBM_GLOSADA ON
		PDV_VD_IT.CD_EMP= PDV_VD_IT_VD_PBM_GLOSADA.CD_EMP AND
		PDV_VD_IT.CD_FILIAL = PDV_VD_IT_VD_PBM_GLOSADA.CD_FILIAL AND
		PDV_VD_IT.CD_VD = PDV_VD_IT_VD_PBM_GLOSADA.CD_VD AND
		PDV_VD_IT.CD_IT = PDV_VD_IT_VD_PBM_GLOSADA.CD_IT 
		LEFT OUTER JOIN PDV_VD_IT_VD_PBM_FINANCEIRO ON
		PDV_VD_IT.CD_EMP= PDV_VD_IT_VD_PBM_FINANCEIRO.CD_EMP AND
		PDV_VD_IT.CD_FILIAL = PDV_VD_IT_VD_PBM_FINANCEIRO.CD_FILIAL AND
		PDV_VD_IT.CD_VD = PDV_VD_IT_VD_PBM_FINANCEIRO.CD_VD AND
		PDV_VD_IT.CD_IT = PDV_VD_IT_VD_PBM_FINANCEIRO.CD_IT 
	WHERE
		PDV_VD_IT.CD_EMP =@CD_EMP
		AND PDV_VD_IT.ST_IT=1
		AND PDV_VD.ST_VD=0
		AND PDV_VD_IT.CD_FILIAL=@CD_FILIAL
		AND PDV_VD_IT.DT_VD BETWEEN @dtInicioMesFechamento AND @dtDiaFinalMesFechamento
		AND RC_CLI_CONV_PBM.FLAG_POSSUI_REPOSICAO_PRODUTOS=1
		AND PDV_VD_IT_VD_PBM_GLOSADA.CD_IT  IS NULL
		AND PDV_VD_IT_VD_PBM_FINANCEIRO.CD_IT IS NULL
		AND EST_PROD_RC_CLI_CONV.REPOSICAO ='S'
	GROUP BY
		PDV_VD_IT.CD_EMP,
		PDV_VD_IT.CD_FILIAL,
		PDV_VD_IT.CD_PROD
	UNION ALL
	SELECT
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_EMP,
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_FILIAL,
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_PROD,
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.QT_MOVIMENTO AS QT_IT_VD,
		0 AS QT_IT_ENT,
		0 AS QT_IT_FECHA
	FROM
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES INNER JOIN GLB_USU ON
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_USU = GLB_USU.CD_USU 
	WHERE
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_EMP =@CD_EMP
		AND RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_FILIAL=@CD_FILIAL
		AND RC_CLI_CONV_PBM_CONTROLE_AJUSTES.DT_MOVIMENTO BETWEEN @dtInicioMesFechamento AND @dtDiaFinalMesFechamento
		AND RC_CLI_CONV_PBM_CONTROLE_AJUSTES.TP_TRANSACAO=1	


	PRINT 'Gerando movimento de entrada '+  convert(varchar,getdate(),108);          
	INSERT INTO #RsVendasPBMProc (  CD_EMP
										 , CD_FILIAL
										 , CD_PROD
										 , QT_IT_VD
										 , QT_IT_ENT
										 , QT_IT_FECHA )
		SELECT
				EST_NF_ENT_IT.CD_EMP
			, EST_NF_ENT_IT.CD_FILIAL
			, EST_NF_ENT_IT.CD_PROD
			, 0 AS QT_IT_VD
			, SUM(EST_NF_ENT_IT.QT_IT) AS QT_IT_ENT
			, 0 AS QT_IT_FECHA
		FROM
			EST_NF_ENT
			INNER JOIN EST_NF_ENT_IT ON EST_NF_ENT.CD_EMP = EST_NF_ENT_IT.CD_EMP
										AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
										AND EST_NF_ENT.CD_NF = EST_NF_ENT_IT.CD_NF
			INNER JOIN ( SELECT
									c.CD_EMP
									, c.CD_PROD
									, 1 AS QT_IT
									, PBM.DT_ATIVAR_CONTROLE
							FROM
									EST_PROD_RC_CLI_CONV c
									INNER JOIN RC_CLI_CONV_PBM pbm ON C.CD_EMP = pbm.CD_EMP
																	AND C.CD_CONV = pbm.CD_CONV
							WHERE pbm.FLAG_POSSUI_REPOSICAO_PRODUTOS = 1
							GROUP BY
										c.CD_EMP
									, c.CD_PROD
									, PBM.DT_ATIVAR_CONTROLE
						) P ON EST_NF_ENT_IT.CD_PROD = P.CD_PROD
				AND EST_NF_ENT_IT.CD_EMP = P.CD_EMP
				AND EST_NF_ENT_IT.DT_ENT >= P.DT_ATIVAR_CONTROLE

			LEFT OUTER JOIN EST_NF_ENT_IT_PBM_GLOSADA ON EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_IT_PBM_GLOSADA.CD_EMP
															AND EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_IT_PBM_GLOSADA.CD_FILIAL
															AND EST_NF_ENT_IT.CD_NF = EST_NF_ENT_IT_PBM_GLOSADA.CD_NF
															AND EST_NF_ENT_IT.CD_PROD = EST_NF_ENT_IT_PBM_GLOSADA.CD_PROD
			INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT D ON D.CD_EMP = EST_NF_ENT.CD_EMP
																	AND D.CD_FILIAL = EST_NF_ENT.CD_FILIAL
																	AND D.CD_NF = EST_NF_ENT.CD_NF
			INNER JOIN V_EST_NF_ENT_DANFE_PROVISORIO_REPOSICAO_PBM REPOSICAO_PBM ON REPOSICAO_PBM.CD_EMP = D.CD_EMP
																					AND REPOSICAO_PBM.CD_CTR = D.CD_CTR
		WHERE EST_NF_ENT_IT.CD_EMP = @CD_EMP
				AND EST_NF_ENT_IT.CD_FILIAL = @CD_FILIAL
				AND EST_NF_ENT_IT.DT_ENT BETWEEN @dtInicioMesFechamento AND @dtDiaFinalMesFechamento
				AND EST_NF_ENT_IT_PBM_GLOSADA.CD_NF IS NULL
				AND EST_NF_ENT.FLAG_REPOSICAO_PBM = 1
				AND REPOSICAO_PBM.PERC_ATEND = 100
		GROUP BY
				EST_NF_ENT_IT.CD_EMP
				, EST_NF_ENT_IT.CD_FILIAL
				, EST_NF_ENT_IT.CD_PROD 
	UNION ALL
	SELECT
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_EMP,
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_FILIAL,
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_PROD,
		0 AS QT_IT_VD,
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.QT_MOVIMENTO AS QT_IT_ENT,
		0 AS QT_IT_FECHA
	FROM
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES INNER JOIN GLB_USU ON
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_USU = GLB_USU.CD_USU 
	WHERE
		RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_EMP =@CD_EMP
		AND RC_CLI_CONV_PBM_CONTROLE_AJUSTES.CD_FILIAL=@CD_FILIAL
		AND RC_CLI_CONV_PBM_CONTROLE_AJUSTES.DT_MOVIMENTO BETWEEN @dtInicioMesFechamento AND @dtDiaFinalMesFechamento
		AND RC_CLI_CONV_PBM_CONTROLE_AJUSTES.TP_TRANSACAO=0	
		
	PRINT 'Gravando cadastro de produtos para controle de estoque ' +  convert(varchar,getdate(),108);   
	INSERT INTO RC_CLI_CONV_PBM_CONTROLE_EST_PROD
	(
	CD_EMP,
	CD_FILIAL,
	CD_PROD,
	DT_CAD,
	QT_SALDO
	)
	SELECT
		DISTINCT
		p.CD_EMP,
		p.CD_FILIAL,
		p.CD_PROD,
		CONVERT(CHAR(10),GETDATE(),112),
		0
	FROM
		#RsVendasPBMProc p LEFT OUTER JOIN RC_CLI_CONV_PBM_CONTROLE_EST_PROD c ON
		p.CD_EMP = c.CD_EMP AND
		p.CD_FILIAL = c.CD_FILIAL AND
		p.CD_PROD = c.CD_PROD 
	WHERE
		C.CD_PROD IS NULL

IF @FLAG_ANALISE=0
BEGIN
	PRINT 'Gravando resultado do movimento ' +  convert(varchar,getdate(),108);   
	UPDATE
		RC_CLI_CONV_PBM_CONTROLE_EST_PROD
	SET 
		RC_CLI_CONV_PBM_CONTROLE_EST_PROD.QT_SALDO=RsProcFinal.QT_SLD_FINAL
	FROM
		RC_CLI_CONV_PBM_CONTROLE_EST_PROD INNER JOIN 
	(SELECT
		CD_EMP,
		CD_FILIAL,
		CD_PROD,
		ISNULL(sum((QT_IT_FECHA + QT_IT_VD) - QT_IT_ENT),0) AS QT_SLD_FINAL
	FROM
		#RsVendasPBMProc 
	GROUP BY
		CD_EMP,
		CD_FILIAL,
		CD_PROD) RsProcFinal on
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_EMP = RsProcFinal.CD_EMP AND
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_FILIAL = RsProcFinal.CD_FILIAL AND
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.CD_PROD = RsProcFinal.CD_PROD AND
	RC_CLI_CONV_PBM_CONTROLE_EST_PROD.QT_SALDO<>RsProcFinal.QT_SLD_FINAL
END
ELSE
BEGIN
	SELECT
		*
	FROM
		#RsVendasPBMProc
END
DROP TABLE #RsVendasPBMProc
end


